<?php
namespace Mtc\Auction\Http\Controllers;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Mtc\Auction\Auction;
use Mtc\Auction\AuctionMember;
use Mtc\Auction\Filter;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;
use Mtc\Auction\Lot;
use Mtc\Core\Currency;
use Mtc\Core\Models\Country;
use Mtc\Members\Facades\MemberAuth;
use Mtc\ShippingManager\TableRate;
use Mtc\ShippingManager\Zone;
use Mtc\ShippingManager\ZoneCountry;
use PHPUnit\Framework\Constraint\Count;

class AuctionController extends Controller
{
    /**
     * Browse page
     *
     * @param Request $request
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function index(Request $request)
    {
       /* if($request->isMethod('post')){
            $applied_filters = $request->input('filters');
        } else {
            $applied_filters = explode('/', trim($request->path(), '/'));
        }*/

        $applied_filters = explode('/', trim($request->path(), '/'));
        
        $search_filter = $request->input('search_filter') ? $request->input('search_filter') : session('search_filter');
        /*
        if (empty($search_filter)) {
            $search_stored_in_url = preg_grep('/q-[a-zA-Z0-9-_]/', $applied_filters);
            if (!empty($search_stored_in_url)) {
                $search_stored_in_url = array_values($search_stored_in_url)[0];
                $search_filter = substr(urldecode($search_stored_in_url), 2);
            }
        }*/
        
         if (empty($search_filter) && !empty($applied_filters)) {
            $search_stored_in_url = [];
            foreach($applied_filters as $applied_filter){
                if(is_array($applied_filter)) {
                    $search_stored_in_url = preg_grep('/q-[a-zA-Z0-9-_]/', $applied_filter);
                }
            }
            if (!empty($search_stored_in_url)) {
                $search_stored_in_url = array_values($search_stored_in_url)[0];
                $search_filter = substr(urldecode($search_stored_in_url), 2);
            }
        }

        $search_type = $request->input('search-auction-type') ?? (Auction::currentLiveAuction() ? 'live' : 'past');
        $auction_slug = Filter::getAuctionSlugFromRequest($request, $applied_filters);
        
        /*if($auction_slug === Filter::ACTIVE_AUCTION_URL_SLUG && is_null(Auction::currentLiveAuction())){
            return redirect()->to(Filter::PAST_AUCTIONS_URL_SLUG);
        }*/
        
        //Check if the live auction page should continue loading the filters or if instead it should show the Upcoming Auction Page
        if($auction_slug == Filter::ACTIVE_AUCTION_URL_SLUG && is_null(Auction::currentLiveAuction()) && Auction::nextUpcomingAuction()){
            return template('Auction/filter/upcoming_auction_landing.twig', [
                'active_auction' => Auction::nextUpcomingAuction()
            ]);
        }
        
        $filter = new Filter($auction_slug);

        //THis used to reference a value on auctions called "admin_type" but this value would never be set
//        if (empty(session()->get('adminId'))) {
//            return redirect()->to('/');
//        }

        $show_not_live_text = false;

        if (!($filter->hasAuction() || $auction_slug === Filter::BUY_IT_NOW_URL_SLUG || $auction_slug === Filter::PAST_AUCTIONS_URL_SLUG || $auction_slug === Filter::WATCHLIST_URL_SLUG)) {
            $show_not_live_text = true;
        }
        $applied_brands=[];
        
        $applied_filters = $filter->processAuxiliaryFilters($applied_filters);
        
//        $applied_brands = $filter->processAuxiliaryFilters($applied_brands);
        $applied_brands = collect();
        
        $filter->applyFilters($request, $applied_filters, $applied_brands, $search_filter);
        
        /*$seo = \Seo::filter($request, $filter);
        $this->page_meta['title'] = $seo->title;
        $this->page_meta['description'] = $seo->description;*/

        $selected_auction_id = 0;
        if (!in_array($auction_slug, [Filter::BUY_IT_NOW_URL_SLUG, Filter::ACTIVE_AUCTION_URL_SLUG, Filter::PAST_AUCTIONS_URL_SLUG, Filter::WATCHLIST_URL_SLUG])) {
            $selected_auction_id = $filter->auction->id;
        } elseif ($auction_slug === Filter::PAST_AUCTIONS_URL_SLUG) {
            $selected_auction_id = -1;
        } elseif ($auction_slug === Filter::BUY_IT_NOW_URL_SLUG) {
            $selected_auction_id = -2;
        } elseif ($auction_slug === Filter::WATCHLIST_URL_SLUG) {
            $selected_auction_id = -3;
        }
        
        if (!is_null($filter->auction) && $filter->auction->is_live) {
            $this->page_meta['title'] = 'Live Auctions';
        } elseif (!is_null($filter->auction)) {
            $this->page_meta['title'] = 'Past Auctions';
        } elseif ($auction_slug === Filter::WATCHLIST_URL_SLUG) {
            $this->page_meta['title'] = 'Watchlist Lots';
        } else {
            $this->page_meta['title'] = 'Buy it Now';
        }

        $this->page_meta['url'] = $_SESSION['last_auction_url'] = $filter->getUrlForFilters($auction_slug);
        
        if ($request->wantsJson()) {
            return [
                'page_meta' => $this->page_meta,
                'items' => !$show_not_live_text ? $filter->getItems() : collect(),
                'filters' => $filter->getFilters(),
                'brands' => $filter->getBrands(),
                'search_filter' => $search_filter,
                'search_type' => $search_type,
                'active_filters' => $filter->getActiveFilters(),
                'active_brands' => $filter->getActiveFilters(),
                'result_count' => $filter->total_count,
                'show_not_live_text' => $show_not_live_text,
                'selected_auction_id' => ($filter->auction) ? $filter->auction->id : 0,
                'auction_details' => ($filter->auction) ? $filter->auction : collect(),
                'sort_options' => $filter->sortByOptions(),
                'per_page_range' => $filter->perPageRange(),
                'is_live_auction_page' => ($filter->auction) ? $filter->auction->is_live : false,
            ];
        }

        $past_auctions = Auction::query()
                                ->whereHas('lots')
                                ->past()
                                ->orderBy('ends_at', 'desc')
                                ->get();

        $search_string = "";

        foreach ($filter->getActiveFilters() as $key => $activeFilter) {
            if (!empty($activeFilter->first())) {
                if ($search_string != '') {
                    $search_string .= "&";
                }
                switch ($key) {
                    case 'country':
                        $search_string .= "c-";
                        break;
                    case 'region':
                        $search_string .= "r-";
                        break;
                    case 'type':
                        $search_string .= "t-";
                        break;
                    case 'age':
                        $search_string .= "a-";
                        break;
                    case 'distillery':
                        $search_string .= "d-";
                        break;
                    case 'lot_type':
                        $search_string .= "lt-";
                        break;
                    default:
                        continue 2;
                        break;
                }
                $search_string .= urldecode($activeFilter->first());
            }
        }
        if (!empty($search_filter)) {
            if ($search_string != '') {
                $search_string .= "&";
            }
            $search_string .= "q-" . urldecode($search_filter);
        }
        if (!empty($search_filter)) {
            if ($search_string != '') {
                $search_string .= "&";
            }
            $search_string .= "sb-" . urldecode($filter->sort_by);
        }
        if (!empty($auction_slug)) {
            if ($search_string != '') {
                $search_string .= "&";
            }
            $search_string .= "au-" . urldecode($auction_slug);
        }

        $breadcrumbs = [
            [
                'id' => 1,
                'url' => '/',
                'name' => 'Home',
            ]
        ];

        if($filter->auction && $filter->auction->is_live){
            $breadcrumbs[] = [
                [
                    'id' => 'auction_' . $filter->auction->id,
                    'url' => '/live-auction',
                    'name' => $filter->auction->name,
                ]
            ];
        } else {
            $breadcrumbs[] = [
                [
                    'id' => 1,
                    'url' => '/past-auctions',
                    'name' => 'Past Auctions',
                ],
            ];
            if($filter->auction) {
                $breadcrumbs[] = [
                    [
                        'id'   => 'auction_' . $filter->auction->id,
                        'url'  => $filter->auction->url,
                        'name' => $filter->auction->name,
                    ]
                ];
            }
        }

        return template('Auction/filter/index.twig', [
            'page_meta' => $this->page_meta,
            'lots' => !$show_not_live_text ? $filter->getItems() : collect(),
            'filters' => $filter->getFilters(),
            'brands' => $filter->getBrands(),
            'search_filter' => $search_filter,
            'search_type' => $search_type,
            'active_filters' => $filter->getActiveFilters(),
            'active_brands' => $filter->getActiveBrands(),
            'filter_names' => $filter->filterNames(),
            'filter_names_multiple' => $filter->filterNames(true),
            'result_count' => $filter->total_count,
            'page' => $filter->page,
            'per_page' => $filter->per_page,
            'sort_by' => $filter->sort_by,
            'per_page_range' => $filter->perPageRange(),
            'sort_options' => $filter->sortByOptions(),
            'past_auctions' => $past_auctions,
//            'selected_auction_id' => $selected_auction_id,
            'show_not_live_text' => $show_not_live_text,
            'search_string' => $search_string,
            'is_live_auction_page' => ($filter->auction)  ? $filter->auction->is_live : false,
            'breadcrumbs' => $breadcrumbs,

            'selected_auction_id' => ($filter->auction) ? $filter->auction->id : 0,
            'auction_details' => ($filter->auction) ? $filter->auction : collect(),
        ]);
    }
    
    public function show(Request $request){
        return $this->index($request);
    }

    /**
     * List past auctions
     *
     * @param $lot_id
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function list()
    {
        $this->page_meta['page_title'] = 'Auction Directory';

        return template('Auction/auctions/past.twig', [
            'past_auctions' => Auction::query()->with('node')->past()->orderBy('ends_at', 'desc')->get(),
            'page_meta' => $this->page_meta,
        ]);
    }
    
    public static function renderUpcomingAuction(){
        $upcoming_auctions = Auction::query()->whereDate('ends_at', '>=', Carbon::now())->orderBy('starts_at')->get();
        echo template('Auction/hooks/upcoming.twig', [
           'upcoming_auctions' => $upcoming_auctions
        ]);
        
    }
    public static function renderShippingBreakdown(){
        
        echo template('Auction/hooks/shipping_breakdown.twig', [
           'countries' => Zone::getUniqueCountriesCodeNameFromEnabled()
        ]);
        
    }
    
    public function shippingBreakdownGetRates(Request $request){
        
        //$zone = ShippingZoneCountry::where('country_id', $country_from->id)->first()->zone_id;

        $zone = Zone::zonesForCountry($request->input('selected_country_to'))->first();

        $costs = TableRate::where('zone_id', $zone->id)
                                 ->where('rate_type', 'weight')
                                 ->where('disabled', 0)
                                 ->where(function ($query) {
                                     $query->where('range_min', '<=', 30)
                                           ->orWhere('range_max', '<=', 30);
                                 })
                                 ->orderBy('range_min')
                                 ->orderBy('range_max')
                                 ->groupBy('range_min')
                                 ->get()
                                 ->map(function ($cost) {
                                     return [
                                         'weight_min' => number_format($cost->range_min, 2),
                                         'weight_max' => number_format($cost->range_max, 2),
                                         'price' => $cost->rate->raw(),
                                         'number_of_bottles' => floor($cost->range_max / 2),
                                         'weight_unit' => 'KG',
                                         'shipping_name' => $cost->name,
                                     ];
                                 });

        $response = [
            'success' => true,
            'country_found' => 'GB',
            'country_to_found' => $request->input('selected_country_to'),
            'country_to_name' => Country::getNameByCode($request->input('selected_country_to')),
            'ship_time' => $zone->ship_time,
            'costs' => $costs,
        ];
        
        echo json_encode($response);
    }

    /**
     * Add global stuff for Auction system
     */
    public static function footerDetails()
    {
        $member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        //Mutate Logged in Member to the AuctionMember Class
        if(!is_null($member)){
            $member = AuctionMember::mutateMemberObject($member);
        }
        
        echo template('Auction/footer_details.twig', [
            'member' => $member,
            'has_pusher' => self::usePusherNotifications(),
            'pusher_key' => env('PUSHER_AUTH'),
            'pusher_cluster' => env('PUSHER_APP_CLUSTER'),
            'enabled_currencies' => Currency::getEnabledCurrencies(),
//            'comparison_currencies' => Currency::getEnabledComparisonCurrencies(),
        ]);

    }



    public static function usePusherNotifications()
    {
        return env('USE_PUSHER_NOTIFICATIONS') && MemberAuth::user();
    }
}