<?php

namespace Mtc\Auction\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Auction\Lot;
use Mtc\Auction\Lot\LotInsurance;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Basket\Item;
use Mtc\Members\Facades\MemberAuth;

class LotBasketInsuranceController extends Controller
{

    /**
     * Add Insurance to all lots in the basket
     * 
     * @return void
     */
    public function addInsurance(){
        $member           = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;
        $basket_interface = App::make(BasketRepositoryInterface::class);
        
        $basket_interface->getItems()->where('purchasable_type', Lot::class)->each(function (Item $item) use ($basket_interface) {
            $lot = $item->purchasable;
            
            if(is_null($lot->insuranceFees)){
                $lot->insuranceFees()->create();
            }

            $basket_interface->addSurcharge($lot->insuranceFees->id, Lot\LotInsurance::class);
            
        });

    }
    
    //Remove the Insurance from the basket

    /**
     * Remove the Insurance from the basket
     * 
     * @return void
     */
    public function removeInsurance(){
        $member           = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;
        $basket_interface = App::make(BasketRepositoryInterface::class);

        $basket_interface->removeSurchargeByType(LotInsurance::class);

    }
    
    public function store(Request $request, BasketRepositoryInterface $basket){;
        if(LotInsurance::staticBasketIsInsurable()){
            if($request->input('insurance')){
                if(!$basket->hasSurcharge(0, LotInsurance::class)){
                    $basket->getItems()->where('purchasable_type', Lot::class)->each(function (Item $item) use ($basket) {
                        $lot = $item->purchasable;

                        if(is_null($lot->insuranceFees)){
                            $lot->insuranceFees()->create()->save();
                        }

                        $basket->addSurcharge($lot->insuranceFees->id, Lot\LotInsurance::class);

                    });
                }
            } else {
                if($basket->hasSurcharge(0, LotInsurance::class)){
                    $basket->removeSurchargeByType(LotInsurance::class);
                }
            }
            
        } else {
            if($basket->hasSurcharge(0, LotInsurance::class)){
                $basket->removeSurchargeByType(LotInsurance::class);
            }
        }
    }
}