<?php

namespace Mtc\Auction\Http\Controllers;

use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Auction\Bid;
use Mtc\Auction\Http\Response\Lotlist;
use Mtc\Auction\Lot;
use Mtc\Auction\Watchlist;
use Mtc\Core\Gate\Auth;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\HasMembersNavigation;

class WatchlistController extends Controller
{
    use HasMembersNavigation;

    const PER_PAGE = 80;

    /**
     * Users Watched Items
     *
     * @param Request $request
     *
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function index(Request $request)
    {
        $this->member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        if (!$this->member->exists) {
            return redirect()->to('/members/login');
        }

        if ($request->wantsJson()) {
            $collection = Lot::query()
                             ->whereHas('watchers', function ($bid_query) {
                                 return $bid_query->where('member_id', $this->member->id);
                             })
                             ->whereIn('status', Lot\Status::$watchlist_statuses)
                             ->setAuctionId($request->input('filters.auction_id'))
                             ->orderBy('ends_at', 'desc')
                             ->orderBy('id', 'desc')
                             ->take(self::PER_PAGE)
                             ->offset($request->input('offset', 0))
                             ->get();

            return (new LotList($collection))->handle();
        }

        $this->page_meta['page_title'] = "My Watchlist";
        $this->page_meta['title']      = "My Watchlist | " . env('APP_NAME');

        app('twig')->addGlobal("is_members_area", true);

        return template('Auction/members/my-watchlist.twig', [
            'page_meta' => $this->page_meta,
            'per_page'  => self::PER_PAGE,
            'member'    => $this->member,
            'sections'  => $this->sections(),
        ]);
    }

    public function update(Request $request)
    {
        $this->member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        if (!$this->member->exists) {
            return redirect()->to('/members/login');
        }
        
        if ($request->input('watch_status') === 'true' && $request->input('id_param') > 0) {
            $target_watchlist = Watchlist::query()
                     ->where('lot_id', $request->input('id_param'))
                     ->where('member_id', $this->member->id)
                     ->first();
            
            $target_watchlist->delete();
            if (is_null(
                Watchlist::query()
                         ->where('lot_id', $request->input('id_param'))
                         ->where('member_id', $this->member->id)
                         ->first()
            )) {
                //success response
                return [
                    'type' => 'success',
                    'message' => 'You are no longer watching this lot'
                ];
            } else {
                //error response
                return [
                    'type' => 'error',
                    'message' => 'You cannot stop watching this lot'
                ];
            }
        } elseif ($request->input('watch_status') === 'false' && $request->input('id_param') > 0) {
            $watchlist_entry = Watchlist::query()
                                        ->firstOrCreate([
                                                            'lot_id'    => $request->input('id_param'),
                                                            'member_id' => $this->member->id,
                                                        ]);
            if (is_null($watchlist_entry)) {
                //error response
                return [
                    'type' => 'error',
                    'message' => 'You cannot watch this lot'
                ];
            } else {
                //success response
                return [
                    'type' => 'success',
                    'message' => 'You are now watching this lot'
                ];
            }
        } else {
            //Catch for invalid data. Should never appear
            return [
                'type' => 'error',
                'message' => 'This site has encountered an error'
            ];
        }
    }

}