<?php

namespace Mtc\Auction\Http\Response;

use Illuminate\Support\Collection;
use Mtc\Auction\Lot;

class AdminLotList
{
    /**
     * list of lots
     *
     * @var Collection $lot_list
     */
    protected $lot_list;

    /**
     * LotList constructor.
     *
     * @param Collection $lot_list
     */
    public function __construct(Collection $lot_list)
    {
        $this->lot_list = $lot_list;
    }

    /**
     * Update collection to have all necessary data
     *
     * @return Collection
     */
    public function handle()
    {
        return $this->lot_list
            ->each(function (Lot $lot) {
                $lot->buyer_name = $lot->buyer->name ?? '';
                //$lot->buyer_details = $lot->buyer ? $lot->buyer->default_address_fields->implode(', ') : '';
                $lot->seller_name = $lot->seller->name ?? '';
                //$lot->seller_details = $lot->seller ? $lot->seller->default_address_fields->implode(', ') : '';
                $lot->auction_name = $lot->auction->name ?? '';
                $lot->url = $lot->getUrlAttribute();
                $lot->lot_id = $lot->getLotIdAttribute();
                $lot->status_text = Lot\Status::$lot_statuses[$lot->status];
                if ($lot->buy_order_id) {
                    $lot->invoice_url = "/members/my-winnings/{$lot->lot_id}/invoice";
                    $lot->admin_order_link = "/shop/admin/orders/manage.order.php?id=" . $lot->buy_order_id;
                }
                /*if (in_array($lot->status, Lot\Status::$winning_statuses)) {
                    $lot->payout_receipt_url = "/members/my-lots/{$lot->lot_id}/receipt";
                }
                $bid_value = $lot->status > Lot\Status::LIVE ? $lot->highest_bid : $lot->latestBid->bid;
                $lot->pricing_info = collect([
                    'Reserve Price: &pound;' . number_format($lot->reserve_price),
                    'Winning Bid: &pound;' . number_format($bid_value),
                ])->implode('<br/>');
                */
                //published doesn't come through to vue
                $lot->is_published = $lot->published;

                $lot->courier_data = $lot->courier_data;

                if ($lot->status === Lot\Status::SUBMITTED_ONLINE) {
                    $lot->delivery_info = collect([
                        'Delivery Method: ' . $lot->deliveryMethod->name,
                    ]);

                    if (!is_null($lot->delivery_method_date)) {
                        $lot->delivery_info->push('Delivery Date: ' . $lot->delivery_method_date);
                    }

                    if (!is_null($lot->collection_point_name)) {
                        $lot->delivery_info->push('Collection Point: ' . $lot->collection_point_name);
                    }

                    $lot->delivery_info = $lot->delivery_info->implode('<br/>');
                } else {
                    $lot->delivery_info = '';
                }
            });
    }
}