<?php

namespace Mtc\Auction\Listeners;

use Mtc\Auction\Contracts\BidNotifier;
use Mtc\Auction\Events\BidUpdate;
use Illuminate\Support\Facades\Cache;
use Mtc\Auction\Bid;

class CacheLotBid implements BidNotifier
{
    /**
     * Cache time to live
     */
    const CACHE_TTL_MINUTES = 15;

    /**
     * Bid that was placed
     *
     * @var Bid $bid
     */
    public  $bid;

    /**
     * BidUpdate constructor.
     *
     * @param Bid $bid
     */
    public function handle(BidUpdate $bid_update)
    {
        $data = $bid_update->getData();
        Cache::forget($this->cacheName($data['lot_id']));
        Cache::remember($this->cacheName($data['lot_id']), 15, function () use ($bid_update) {
            return $bid_update->getData();
        });
    }

    /**
     * Get the cache name for lot bid info
     *
     * @param $lot_id
     * @return string
     */
    protected function cacheName($lot_id)
    {
        return "lot_bid_info_{$lot_id}";
    }
}