<?php

namespace Mtc\Auction\Log;

use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Monolog\Handler\RotatingFileHandler;
use Mtc\Plugins\Courier\Classes\Config\Config;

class Log {

    protected static $instance;

    static public function getLogger()
    {
        if (!self::$instance) {
            self::configureInstance();
        }

        return self::$instance;
    }

    protected static function configureInstance()
    {

        //TODO move setting to DB
//        $log_path = '/home2/stawhisk/logs/auction-platform/';
//        $log_file = 'auction-platform.log';
//        $log_name = 'auction-platform';
        $log_path = config('auction.logging.path');
        $log_file = config('auction.logging.file');
        $log_name = config('auction.logging.name');
        $dir = $log_path;

        if (!file_exists($dir)){
            mkdir($dir, 0777, true);
        }

        $logger = new Logger($log_name);
        $logger->pushHandler(new RotatingFileHandler($dir . $log_file, self::getLoggingLevel()));
        self::$instance = $logger;
        return self::$instance;

    }

    public static function getLoggingLevel()
    {

        if (getenv('LOG_LEVEL') === 'debug') {
            return Logger::DEBUG;
        }

        return Logger::ERROR;
    }

    public static function debug(string $message, array $context = [])
    {
        self::getLogger()->debug($message, $context);
    }

    public static function info(string $message, array $context = [])
    {
        self::getLogger()->info($message, $context);
    }

    public static function notice(string $message, array $context = [])
    {
        self::getLogger()->notice($message, $context);
    }

    public static function warning(string $message, array $context = [])
    {
        self::getLogger()->warning($message, $context);
    }

    public static function error(string $message, array $context = [])
    {
        self::getLogger()->error($message, $context);
    }

    public static function critical(string $message, array $context = [])
    {
        self::getLogger()->critical($message, $context);
    }

    public static function alert(string $message, array $context = [])
    {
        self::getLogger()->alert($message, $context);
    }

    public static function emergency(string $message, array $context = [])
    {
        self::getLogger()->emergency($message, $context);
    }


}