<?php

namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Model;
use Mtc\Auction\Lot;

class Custom extends Model
{
    use BelongsToLot;
    
    /**
     * @var array $guarded
     */
    protected $guarded = [
        'id'
    ];

    /**
     * @var bool $timestamps
     */
    public $timestamps = false;
    
    /**
     * Classes associated table
     *
     * @var string $table
     */
    protected $table = 'auction_lot_custom';

    /**
     * Relationship with Lot
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function lot()
    {
        return $this->belongsTo(Lot::class);
    }
}