<?php
namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\Auction\Lot;

/**
 * Lot Fee Class
 *
 * @author Florin Radica <florin.radica@mtcmedia.co.uk>
 */
Class Fee extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'auction_lot_fees';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'lot_id',
        'amount',
        'description',
        'PLU',
    ];

    public static function feeExist(int $lot_id ,string $plu)
    {

        $fee_exist = false;
        $fee = Fee::query()
            ->select('id')
            ->where('lot_id' ,$lot_id)
            ->where('PLU' ,strtoupper($plu))
            ->get();

        if($fee->count() > 0) {

            $fee_exist = true;

        }

        return $fee_exist;

    }

    /**
     * Get the lot that owns the fee.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function lot()
    {
        return $this->belongsTo(Lot::class);
    }
}
