<?php

namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Model;
use Mtc\Auction\Lot;
use Mtc\Basket\Events\BasketItemCreating;
use Mtc\Money\Events\LoadPriceModifiers;
use Mtc\Money\HasPrices;
use Mtc\Money\Price;

class LateFees extends Model
{
    use HasPrices;

    /**
     * Handle the event
     * @param BasketItemCreating $event
     * @return array
     */
    public function handle(BasketItemCreating $event)
    {
        $extra = [];
        dd($event);
        if ($item['PLU'] !== Lot::LOT_PURCHASE_PLU) {
            return $extra;
        }
        
        
        
        

        $lot = Lot::query()
                  ->whereHas('basketVariant', function ($variant_query) use ($item) {
                      $variant_query->where('id', $item['sizeid']);
                  })
                  ->first();

        if (!$lot || ($lot && $lot->ignore_late_payment_fee)) {
            return $extra;
        }

        $late_payment_fee_percentage = shop_setting('late_payment_fee_percentage');

        if (empty($late_payment_fee_percentage)) {
            return $extra;
        }

        if (Carbon::now()->diffInDays($lot->ends_at) > shop_setting('late_payment_fee_workdays')) {
            return [
                [
                    'item_price' => $late_payment_fee_percentage / 100 * $item['item_price'],
                    'item_price_exvat' => $late_payment_fee_percentage / 100 * $item['item_price_exvat'],
                    'line_total' => $late_payment_fee_percentage / 100 * $item['item_price'],
                    'line_total_exvat' => $late_payment_fee_percentage / 100 * $item['item_price_exvat'],
                    'cost_subtotal' => $late_payment_fee_percentage / 100 * $item['item_price'],
                    'cost_subtotal_exvat' => $late_payment_fee_percentage / 100 * $item['item_price_exvat'],
                    'late_payment_fee' => true,
                ]
            ];
        }

        return $extra;
    }
    
    public function lot(){
        return $this->belongsTo(Lot::class);
    }

    /**
     * Get name attribute
     *
     * @return mixed
     */
    public function getNameAttribute()
    {
        return  $this->lot->name . ' Late Fees';
    }

    /**
     * @return mixed
     * @throws \Exception
     */
    public function getDisplayPriceAttribute()
    {
        $late_payment_fee_percentage = config('auction.settings.default_late_payment_fee_percentage');

        $price = $this->lot->hammer_price / 100 * $late_payment_fee_percentage;

        if($price > 0) {
            return $price;
        }
        $price = new Price($price, $this->taxAttribute());
        $price->calculate();

        return $price;
    }

    /**
     * @return mixed
     * @throws \Exception
     */
    public function getPriceAttribute()
    {
        $late_payment_fee_percentage = config('auction.settings.default_late_payment_fee_percentage');
        
        $price = $this->lot->hammer_price / 100 * $late_payment_fee_percentage;
        
        if($price > 0) {
            return $price;
        }
        $price = new Price($price, $this->taxAttribute());
        $price->calculate();

        return $price;
    }

    public function taxAttribute()
    {
        //no tax on these fees
        return 0;
    }
    
}