<?php

namespace Mtc\Auction\Lot;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\Auction\Lot;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Money\Price;

class LotInsurance extends Model
{

    protected $table = 'auction_lot_insurance_fees';



    public function lot()
    {
        return $this->belongsTo(Lot::class, 'lot_id');
    }

    /**
     * Check if the Basket is insurable
     *
     * @return bool
     */
    public function basketIsInsurable(){
        $basket_interface = App::make(BasketRepositoryInterface::class);
        $storage_delivery_selected = $basket_interface->basket->surcharges()->where('surcharge_type', 'delivery')->where('surcharge_id', config('auction.storage.delivery_id'))->first();

        //return $basket_interface->hasItemType(Lot::class) && !$storage_delivery_selected;
        return ($basket_interface->basket
                    ->items
                    ->filter(function ($item) {
                        return $item->purchasable_type == Lot::class;
                    })
                    ->count() > 0) && !$storage_delivery_selected;
    }
    
    /**
     * Check if the Basket is insurable
     *
     * @return bool
     */
    public static function staticBasketIsInsurable(){
        $basket_interface = App::make(BasketRepositoryInterface::class);
        $storage_delivery_selected = $basket_interface->getModel()->surcharges()->where('surcharge_type', 'delivery')->where('surcharge_id', config('auction.storage.delivery_id'))->first();


        
        
//        return $basket_interface->hasItemType(Lot::class) && !$storage_delivery_selected;
        return ($basket_interface->getModel()
                    ->items
                    ->filter(function ($item) {
                        return $item->purchasable_type == Lot::class;
                    })
                    ->count() > 0) && !$storage_delivery_selected;
    }
    
    

    /**
     * Show price attribute surcharge
     *
     * @return mixed
     */
    public function getPriceAttribute()
    {
        $insurance_fee_percentage = config('auction.settings.insurance_fee_percentage') ?? 3;

        $basket_interface = App::make(BasketRepositoryInterface::class);
        
        $lots = $basket_interface->getItems()->where('purchasable_type', Lot::class)->pluck('purchasable.hammer_price')->toArray();
        
        $price = (array_sum($lots) / 100) * $insurance_fee_percentage;
        
        $price = new Price($price/*, $this->taxAttribute()*/);
        $price->calculate();

        return $price;
    }

    /**
     * Show name attribute from surcharge
     *
     * @return mixed
     */
    public function getNameAttribute()
    {
        return env('APP_NAME'). ' Shipping Insurance';
    }

    /**
     * Show price attribute surcharge
     *
     * @return mixed
     */
    public function getTaxAttribute()
    {
        return $this->surcharge->getPriceAttribute()
                               ->tax();
    }

    public function taxAttribute()
    {
        return 0;
    }
    
    

}