<?php

namespace Mtc\Auction\Lot;

use Carbon\Carbon;
use Mtc\Auction\Lot;

class Recent
{

    /**
     * Session key
     */
    const SESSION_KEY = 'recently_viewed_lots';

    public static function add($lot_id)
    {
        if (!isset($_SESSION[self::SESSION_KEY])) {
            $_SESSION[self::SESSION_KEY] = [];
        }

        if (in_array($lot_id, $_SESSION[self::SESSION_KEY])) {
            $start = array_search($lot_id, $_SESSION[self::SESSION_KEY]);
            unset($_SESSION[self::SESSION_KEY][$start]);
        }

        array_unshift($_SESSION[self::SESSION_KEY], $lot_id);

        if (count($_SESSION[self::SESSION_KEY]) > config('auction.settings.recently_viewed_lots_max') + 1) {
            array_pop($_SESSION[self::SESSION_KEY]);
        }
    }


    /**
     * Get the recently viewed lots
     *
     * @param int $exclude_id
     */
    public static function get(int $exclude_id = 0)
    {
        return Lot::query()
                  ->with([
                      'defaultImage',
                  ])
                  ->whereIn('id', $_SESSION[self::SESSION_KEY] ?? [])
                  ->where('id', '!=', $exclude_id)
                  ->get()
                  ->sortBy(function($lot) {
                      return array_search($lot->id, $_SESSION[self::SESSION_KEY]);
                  })
                  ->map(function ($lot) {
                      $lot->time_left = Carbon::now()->diffInSeconds($lot->ends_at);
                      return $lot;
                  });
    }
}