<?php

namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Model;
use Mtc\Auction\Lot;

class SellerPayout extends Model
{
    protected $table = 'auction_lot_payouts';
    
    protected $fillable = [
        'payout_reference',
        'payout_details',
        'payout_made_at'
    ];

    protected $casts = [
        'payout_details' => 'encrypted',
    ];

    /**
     * Lot relationship
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function lot(){
        return $this->belongsTo(Lot::class, 'lot_id');
    }
}