<?php

namespace Mtc\Auction\Lot;

/**
 * Class Lot Status
 * Used to identify lot status
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Status
{
    /**
     * Lot statuses as constants to allow read-friendly usage in code
     */
    const NOT_PAID = 0;
    const REGISTERED = 1;
    const IN_TRANSIT = 2;
    const RECEIVED = 3;
    const READY = 4;
    const LIVE = 5;
    const NOT_SOLD = 6;
    const SOLD = 7;
    const PAID = 8;
    const SHIPPED = 9;
    const CANCELLED = 10;
    const RETURNED = 11;
    const SUBMITTED_ONLINE = 12;
    const RELISTED = 13;
    const TO_BE_RETURNED = 14;

    /**
     * All lot statuses
     *
     * @var array $lot_statuses
     */
    public static $lot_statuses = [
        self::NOT_PAID => 'In Progress',
        self::SUBMITTED_ONLINE => 'Submitted Online',
        self::REGISTERED => 'Registered',
        self::IN_TRANSIT => 'In Transit to Business',
        self::RECEIVED => 'Received',
        self::READY => 'Processed / Ready for live',
        self::LIVE => 'Live',
        self::NOT_SOLD => 'Not Sold',
        self::SOLD => 'Sold',
        self::PAID => 'Payment Received',
        self::SHIPPED => 'Shipped',
        self::CANCELLED => 'Cancelled',
        self::RETURNED => 'Returned',
        self::RELISTED => 'Relisted',
        self::TO_BE_RETURNED => 'To be Returned',
    ];

    /**
     * Lot statuses for pre auction
     *
     * @var array
     */
    public static $pre_auction_statuses = [
        self::NOT_PAID,
        self::SUBMITTED_ONLINE,
        self::REGISTERED,
        self::IN_TRANSIT,
        self::RECEIVED,
        self::READY,
    ];

    /**
     * Lot statuses for won lots
     *
     * @var array
     */
    public static $winning_statuses = [
        self::SOLD,
        self::PAID,
        self::SHIPPED,
    ];

    /**
     * Lot statuses for past lots
     *
     * @var array
     */
    public static $past_statuses = [
        self::CANCELLED,
        self::NOT_SOLD,
        self::SOLD,
        self::PAID,
        self::SHIPPED,
        self::RELISTED,
    ];

    /**
     * Lot statuses for future lots
     *
     * @var array
     */
    public static $future_statuses = [
        self::REGISTERED,
        self::IN_TRANSIT,
        self::RECEIVED,
        self::SUBMITTED_ONLINE,
        self::READY,
    ];

    /**
     * Lot statuses for buy it now lots
     *
     * @var array
     */
    public static $buy_it_now_statuses = [
        self::READY,
        self::LIVE,
        self::NOT_SOLD,
    ];

    /**
     * Lot statuses for watchlist lots
     *
     * @var array
     */
    public static $watchlist_statuses = [
        self::NOT_PAID,
        self::SUBMITTED_ONLINE,
        self::REGISTERED,
        self::IN_TRANSIT,
        self::RECEIVED,
        self::READY,
        self::LIVE,
        self::NOT_SOLD,
        self::SOLD,
    ];
    
    public static $purchasable_statuses = [
        self::SOLD,
    ];
}