<?php

namespace Mtc\Auction\Lot;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\Auction\AuctionMember;
use Mtc\Basket\Contracts\Purchasable;
use Mtc\Members\Member;
use Mtc\Money\HasPrices;
use Mtc\Money\Price;
use Mtc\Orders\Events\OrderStatusChange;
use Mtc\Orders\Order;
use Mtc\Auction\Lot\Status;
use Mtc\Auction\Lot;
use Mtc\Auction\Auction;
use Mtc\Orders\Status as OrderStatus;

class StorageLocation extends Model
{
    /**
     * Table name
     *
     * @var string $table
     */
    protected $table = 'auction_storage_lot_locations';

    /**
     * Mass assignable attributes
     *
     * @var array $fillable
     */
    protected $fillable = [
        'name',
        'description',
        'address',
    ];
    
    public function stored_lots()
    {
        return $this->hasMany(Storage::class, 'location_id');
    }

}