<?php

namespace Mtc\Auction\Member;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\Auction\MembersAddress\MembersAddress;

/**
 * @property $id
 * @property $name
 * @property $email
 * @property $email_verified_at
 * @property $contact_no
 * @property $mobile_no
 * @property $password
 * @property $default_address_id
 * @property $remember_token
 * @property $created_at
 * @property $updated_at
 * @property $basket_id
 */

class Member extends Model {

    protected $table = 'members';

    public static function addressBilling(int $member_id)
    {

        $address = Member::find($member_id);
        return MembersAddress::find($address->default_address_id);

    }

}