<?php

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Model;

class PickupMethod extends Model
{
    /**
     * Table name
     *
     * @var string $table
     */
    protected $table = 'auction_lot_pickup_methods';
    
    /**
     * Mass assignable attributes
     *
     * @var array $fillable
     */
    protected $fillable = [
        'name',
        'description',
        'reminder',
        'has_date_picker',
        'has_collection_points',
    ];

    /**
     *
     * @var array $reminders
     */
    public static $reminders = [
        '' => 'No Reminder',
        ];

    /**
     * Lots have pickup method specified
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function lot()
    {
        return $this->hasMany(Lot::class, 'pickup_method_id');
    }
}