<?php

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Model;

class PriceTrend extends Model
{
    /**
     * Classes associated table
     *
     * @var string $table
     */
    protected $table = 'auction_lot_price_trends';

    protected $fillable = [
        'catalogued_lot_name'
    ];

    /**
     * Relationship with Auction
     *
     * @return \Illuminate\Database\Eloquent\Relations\hasMany
     */
    public function entries()
    {
        return $this->hasMany(PriceTrendEntry::class, 'price_trend_id');
    }

    public static function idNameList()
    {
        return self::query()
                   ->pluck('catalogued_lot_name', 'id');
    }
}