<?php

namespace Mtc\Auction\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Route;

/**
 * Class AuctionServiceProvider
 *
 * @package Mtc\Auction
 */
class AuctionRoutesServiceProvider extends RouteServiceProvider
{
    /**
     * Namespace for routes
     *
     * @var string
     */
    protected $namespace = '\\';
    
    /**
     * Bootstrap the application services.
     */
    public function map()
    {
        $this->mapWebRoutes();
        $this->apiRoutes();
    }

    /**
     * Web routes
     */
    public function mapWebRoutes()
    {
        Route::middleware('web')->group(\dirname(__DIR__, 2) . '/routes/web.php');
    }

    /**
     * api routes
     */
    public function apiRoutes()
    {
        Route::middleware('api')->group(\dirname(__DIR__, 2) . '/routes/api.php');
    }
    
}
