<?php

namespace Mtc\Auction\Seeds;

use Illuminate\Database\Seeder;

class AuctionAdminMenuSeeder extends Seeder
{
    public function run()
    {
        $auction_menu = \Mtc\Core\Admin\Menu::query()
            ->firstOrCreate([
                'title' => 'Auction',
            ], [
                'icon' => 'fas fa-gavel',
            ]);

        if ($auction_menu->id) {
            $auction_sub_menu = self::getAuctionSubMenu();
            foreach ($auction_sub_menu as $sub_menu) {
                $roles = $sub_menu['roles'] ?? [];
                unset($sub_menu['roles']);
                $child = $auction_menu->children()
                    ->create($sub_menu);
                \Mtc\Core\Admin\Menu::grantMenuPermissionToRole($child, $roles);
            }
        }
    }

    /**
     * Get admin menu (shop submenu) data
     *
     * @return array
     */
    protected function getAuctionSubMenu(): array
    {
        return [
            [
                'title' => 'Auctions',
                'path' => '/admin/auctions',
                'activePath' => '/admin/auctions',
                'constant' => '',
                'order' => 0,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Lots',
                'path' => '/admin/lots',
                'activePath' => '/admin/lots',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Latest Bids',
                'path' => '/admin/bids',
                'activePath' => '/admin/bids',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Lot Storage',
                'path' => '/admin/lots/storage',
                'activePath' => '/admin/lots/storage',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Bidding increments',
                'path' => '/admin/bids/increments',
                'activePath' => '/admin/bids/increments',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Manage Lot Pickup Methods',
                'path' => '/admin/lot-pickup',
                'activePath' => '/admin/lot-pickup',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Manage Price Trends',
                'path' => '/admin/price-trends',
                'activePath' => '/admin/price-trends',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Manage Lot Collection Points',
                'path' => '/admin/lot-collection-points',
                'activePath' => '/admin/lot-collection-points',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Auction Settings',
                'path' => '/admin/auction/settings',
                'activePath' => '/admin/auction/settings',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Lot Custom Fields',
                'path' => '/admin/lots/custom-fields',
                'activePath' => '/admin/lots/custom-fields',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Lot Custom Fields Sets',
                'path' => '/admin/lots/custom-field-sets',
                'activePath' => '/admin/lots/custom-field-sets',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
            [
                'title' => 'Auction Member Fees',
                'path' => '/admin/auction/member-fees',
                'activePath' => '/admin/auction/member-fees',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator',
                ],
            ],
        ];
    }
}