<?php

namespace Mtc\Auction\Validators;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Basket\Validators\BaseBasketValidator;
use Mtc\Foundation\Rules\ValidPhoneNumber;
use Mtc\Foundation\Rules\ValidPostcode;

/**
 * Class BasketValidator
 *
 * @package Mtc\Basket
 */
class BasketItemValidator extends BaseBasketValidator
{
    /**
     * Check if basket items are valid
     *
     * @return bool
     */
    public function handle()
    {
        $allow_only_lot_item = config('basket.allow_only_lot_item');
        if (
            config('basket.allow_backorders') !== true
            || config('basket.check_stock_on_items_when_basket_doesnt_check_stock')
        ) {
            $passes = $this->checkItemsOutOfStock();
        }
        if($allow_only_lot_item == 1
        ) {

            if($this->nonLotItemExist())
            {
                $this->repository->setErrors(['delivery_method' => 'You cannot select Storage as this option is only available when paying for lots']);
            }
        }

        return config('basket.allow_backorders') ? true : $passes;
    }

    /**
     * Check if stock values are ok for the basket
     *
     * @return bool
     */
    protected function checkItemsOutOfStock()
    {
        return collect($this->basket->items)
                ->filter(function ($item) {
                    $item->in_stock = $item->purchasable->getStock() >= $item->quantity;
                    return !$item->in_stock;
                })
                ->count() == 0;
    }

    protected function nonLotItemExist()
    {
        $non_lot_item_exist = false;
        $allow_purchasable_item_type = config('basket.allow_purchasable_item_type');

        foreach ($this->basket->items as $item) {
            if(!in_array($item->purchasable_type,$allow_purchasable_item_type))
            {
                $non_lot_item_exist = true;
                break;
            }
        }
        return $non_lot_item_exist;
    }

}
