<?php

namespace Mtc\AutoTraderStock\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;
use Mtc\AutoTraderStock\AutoTraderFileEngine;
use Mtc\AutoTraderStock\Console\Commands\ImportStockCommand;
use Mtc\AutoTraderStock\Contracts\AutoTraderImportContract;

class AutoTraderProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/auto_trader_stock.php', 'auto_trader_stock');
    }

    public function boot()
    {
        if ($this->app->runningUnitTests()) {
            return;
        }
        $this->app->bind(AutoTraderImportContract::class, config('auto_trader_stock.import_map'));

        $this->app->bind(AutoTraderFileEngine::class, function () {
            return new AutoTraderFileEngine(
                config('auto_trader_stock'),
                $this->app->make(AutoTraderImportContract::class)
            );
        });

        $this->commands([
            ImportStockCommand::class,
        ]);

        $this->app->booted(function () {
            $this->app->make(Schedule::class)->command(ImportStockCommand::class)->dailyAt('09:04');
            $this->app->make(Schedule::class)->command(ImportStockCommand::class)->dailyAt('17:04');
        });
    }
}
