<?php

namespace Mtc\AutoTraderStock\Console\Commands;

use Illuminate\Console\Command;
use Mtc\AutoTraderStock\AutoTraderFileEngine;

class ImportStockCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'auto-trader:import';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import AutoTrader Stock';

    /**
     * @var AutoTraderFileEngine
     */
    private $driver;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(AutoTraderFileEngine $file_driver)
    {
        if (config('auto_trader_stock.driver') === 'file') {
            $this->driver = $file_driver;
        }
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle(): void
    {
        if (config('auto_trader_stock.enabled') !== true) {
            $this->error('Sync Disabled');
            return;
        }

        $this->info('Processing Started');
        $this->driver->run();
        $this->info('Processing Finished');
    }
}
