<?php

namespace Mtc\AutoTraderStock;

use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\AutoTraderStock\Contracts\AutoTraderEngineContract;
use Mtc\AutoTraderStock\Contracts\AutoTraderImportContract;

class AutoTraderFileEngine implements AutoTraderEngineContract
{
    private $config;

    private $importer;

    public function __construct(array $config, AutoTraderImportContract $importer)
    {
        $this->config = $config;
        $this->importer = $importer;
    }

    public function run($quick_sync = false)
    {
        Excel::import($this->importer, $this->pathToImportFile());
    }

    public function pathToImportFile(): string
    {
        $file_name = $this->config['import_file'];
        return Storage::disk($this->config['disk_name'])->path($file_name);
    }

    public function isApiDriver(): bool
    {
        return false;
    }
}
