<?php

namespace Mtc\AutoTraderStock;

use Maatwebsite\Excel\Facades\Excel;
use Mtc\AutoTraderStock\Contracts\AutoTraderEngineContract;
use Mtc\AutoTraderStock\Contracts\AutoTraderImportContract;

class AutoTraderFileEngine implements AutoTraderEngineContract
{
    private $config;

    private $importer;

    public function __construct(array $config, AutoTraderImportContract $importer)
    {
        $this->config = $config;
        $this->importer = $importer;
    }

    public function run($quick_sync = false)
    {
        Excel::import($this->importer, $this->config['import_file'], 'stock');
    }

    public function isApiDriver(): bool
    {
        return false;
    }
}
