<?php

namespace App\Actions\IntegrationVerification;

use App\Modules\Stock\Skupenet;

class VerifySkupenet
{
    public function __construct(private Skupenet $provider)
    {
        //
    }

    public function verify()
    {
        if ($this->ableToRetrieveVehicles() === false) {
            return response([
                'message' => __('integrations.unable_to_connect', ['dealer' => 'Skupenet']),
            ], 422);
        }

        return true;
    }

    private function ableToRetrieveVehicles(): bool
    {
        return $this->provider->fetchVehicles($this->provider->endpoint())->isNotEmpty();
    }
}
