<?php

namespace App\Http\Controllers;

use App\Http\Requests\LeaseImportUpdateMakeRequest;
use Mtc\MercuryDataModels\VehicleMake;

class LeaseImportMakeController
{
    public function index()
    {
        return VehicleMake::query()
            ->orderBy('name')
            ->paginate();
    }

    public function update(LeaseImportUpdateMakeRequest $request)
    {
        collect($request->input('makes') ?? [])->each(function ($make) {
            VehicleMake::query()
                ->where('id', $make['id'])
                ->update([
                    'keyloop_import_enabled' => $make['keyloop_import_enabled'],
                ]);
        });
    }
}
