<?php

namespace App\Http\Controllers;

use App\Http\Requests\LeaseImportUpdateModelRequest;
use Mtc\MercuryDataModels\VehicleModel;

class LeaseImportModelController extends Controller
{
    public function index($make_id)
    {
        return VehicleModel::query()
            ->where('make_id', $make_id)
            ->orderBy('name')
            ->paginate();
    }

    public function update(LeaseImportUpdateModelRequest $request)
    {
        collect($request->input('models') ?? [])->each(function ($model) {
            VehicleModel::query()
                ->where('id', $model['id'])
                ->update([
                    'keyloop_import_enabled' => $model['keyloop_import_enabled'],
                ]);
        });
    }
}
