<?php

namespace App\Http\Requests;

use App\Rules\SettingTypeRule;
use App\Tier;
use Illuminate\Foundation\Http\FormRequest;

class StoreSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return tenant()->tier === Tier::ENTERPRISE->value;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'tab' => 'required',
            'section' => 'required',
            'name' => 'required',
            'type' => [
                'required',
                new SettingTypeRule(),
            ],
            'config_key' => [
                'required',
                'alpha_dash',
                'unique:settings,config_key',
            ],
            'description' => 'sometimes',
        ];
    }
}
