<?php

namespace App\Modules\VehicleTrims\Http\Controllers;

use App\Modules\VehicleTrims\Http\Requests\UpdateTrimRequest;
use App\Modules\VehicleTrims\Http\Resources\VehicleTrimList;
use App\Modules\VehicleTrims\Http\Resources\VehicleTrimView;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehicleTrim;

class VehicleTrimController
{
    public function index(Request $request): VehicleTrimList
    {
        return new VehicleTrimList(VehicleTrim::query()
            ->select(['vehicle_trims.*'])
            ->leftJoin('vehicle_makes', 'vehicle_trims.make_id', 'vehicle_makes.id')
            ->leftJoin('vehicle_models', 'model_id', 'vehicle_models.id')
            ->orderBy('vehicle_makes.name')
            ->orderBy('vehicle_models.name')
            ->orderBy('vehicle_trims.name')
            ->paginate());
    }

    public function show(VehicleTrim $vehicle_trim): VehicleTrimView
    {
        return new VehicleTrimView($vehicle_trim);
    }

    public function store(Request $request): VehicleTrimView
    {
        $trim = VehicleTrim::query()->create($request->input());
        return new VehicleTrimView($trim);
    }

    public function update(UpdateTrimRequest $request, VehicleTrim $vehicle_trim): VehicleTrimView
    {
        $vehicle_trim->update($request->input());
        return new VehicleTrimView($vehicle_trim);
    }

    public function destroy(Request $request, VehicleTrim $vehicle_trim): VehicleTrimList
    {
        $vehicle_trim->delete();
        return $this->index($request);
    }

    public function copy(Request $request, VehicleTrim $vehicle_trim): VehicleTrimView
    {
        $copy = VehicleTrim::query()->create($vehicle_trim->toArray());
        return new VehicleTrimView($copy);
    }
}
