<?php

namespace App;

use App\Events\TenantBroadcastEvent;
use Mtc\Notifications\Contracts\NotificationModel;

class NotificationRepository extends \Mtc\Notifications\NotificationRepository
{
    public function addNotification(
        string $severity,
        string $message,
        $details,
        $required_permission,
        $source
    ): NotificationModel {
        /** @var NotificationModel $notification */
        $notification = $this->notification_model->newQuery()
            ->create([
                'severity' => $severity,
                'message' => $message,
                'details' => is_string($details) ? $details : json_encode($details),
                'source' => $source,
                'recipient_permission_level' => $required_permission,
            ]);

        event(new TenantBroadcastEvent($notification, tenant('id'), 'notification.new'));
        return $notification;
    }
}
