<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LCVFinanceEnabledSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Filter',
            'group' => 'General',
            'name' => 'Show Finance calculator for LCV vehicles',
            'config_key' => 'vehicle-fpa-show-finance',
            'type' => 'boolean',
            'value' => true,
            'min_tier' => 'standard',
            'description' => 'When disabled will not show finance calculator for LCV vehicles',
            'order' => 3,
        ]);

    }
}
