@extends('crm::emails.flex-auto.layout', [
    'subject' => $enquiry->subject ?? 'Thank you for your enquiry',
    'site_name' => $site_name,
    'site_logo' => $site_logo,
    'site_url' => $site_url,
    'colours' => $colours,
])


@php
    $finance_url = \App\Facades\Site::url('/finance');
    $valuation_url = \App\Facades\Site::url('/valuation');
    $vehicle_url = '';
    if ($enquiry->reason && $enquiry->reason instanceof \Mtc\MercuryDataModels\Vehicle) {
        $vehicle_url = \App\Facades\Site::vehicleUrl($enquiry->reason);
    }
@endphp

@section('content')
    <!-- ALERT BLOCK -->
    <tr>
        <td valign="top" bgcolor="#E5EFFF" style="background-color:#E5EFFF;">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top">
                        <table cellpadding="10" cellspacing="0" border="0" width="100%">
                            <tr>
                                <td valign="top" align="center">
                                    <table cellpadding="0" cellspacing="0" border="0" align="center">
                                        <tr>
                                            <td valign="middle" align="center">
                                                <h1 style="color:#1F2424 !important; margin:0; font-size:36px; font-weight:500; letter-spacing:-0.72px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; line-height: 1; padding: 0 0 15px;">
                                                    Thank you for your enquiry
                                                </h1>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td valign="middle" align="center">
                                                <div style="font-size: 18px;color:#1F2424">Your request has now been passed on to a member of our team</div>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>

    <tr>
        <td bgcolor="#E5EFFF" style="background-color:#E5EFFF;" width="100%" height="40"></td>
    </tr>
    <!-- END OF ALERT BLOCK -->
    <!-- CONTENT AREA -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td height="50"></td>
                </tr>

                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top" align="center">
                        {!! str_replace(
                            [
                                '[finance-button]',
                                '[valuation-button]',
                                '[reserve-button]',
                                '<p>',
                                '<h1>',
                                '<h2>',
                                '<h3>',
                                '<h4>',
                                '<h5>',
                                '<h6>',
                                '<ul>',
                                '<li>',
                                '<ol>',
                                '<td>',
                            ],
                            [
                                '<table cellpadding="0" cellspacing="0" border="0" align="left" width="100%"><tr><td valign="top">
                                <table cellpadding="0" cellspacing="0" border="0" align="left" width="400">
                                    <tr>
                                        <td align="center" style="border-radius: 5px; background-color: #FF981F;">
                                            <a rel="noopener" href="' . $finance_url . '" target="_blank" style="font-size: 22px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 700; text-decoration: none;border-radius: 5px; padding: 14px 18px; border: 1px solid #FF981F; display: inline-block;">
                                                <img class="imageFix" src="' . config('app.url') . '/api/assets/flex-auto/icons/shield.png" alt="Shield" title="Shield" width="19" height="19" style="display:inline-block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" /> Check Finance <br />
                                            </a>
                                        </td>
                                    </tr>
                                </table></td></tr><tr>
    <td height="40"></td>
</tr></table>',
                                '<table cellpadding="0" cellspacing="0" border="0" align="left" width="100%"><tr><td valign="top">
                                <table cellpadding="0" cellspacing="0" border="0" align="left" width="400">
                                    <tr>
                                        <td align="center" style="border-radius: 5px; background-color: #324E60;">
                                            <a rel="noopener" href="' . $valuation_url . '" target="_blank" style="font-size: 22px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 600; text-decoration: none;border-radius: 5px; padding: 26px 18px; border: 1px solid #324E60; display: inline-block;">
                                                Value my car
                                            </a>
                                        </td>
                                    </tr>
                                </table></td></tr><tr>
    <td height="40"></td>
</tr></table>',
                                '<table cellpadding="0" cellspacing="0" border="0" align="left" width="100%"><tr><td valign="top">
                                <table cellpadding="0" cellspacing="0" border="0" align="left" width="400">
                                    <tr>
                                        <td align="center" style="border-radius: 5px; background-color: #0E3A2F;">
                                            <a rel="noopener" href="' . $vehicle_url . '?journey=reserve" target="_blank" style="font-size: 22px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 700; text-decoration: none;border-radius: 5px; padding: 16px 18px; border: 1px solid #0E3A2F; display: inline-block;">
                                                Reserve for £99
                                            </a>
                                        </td>
                                    </tr>
                                </table></td></tr><tr>
    <td height="40"></td>
</tr></table>',
                                '<p style="color:#1F2424; margin:0 0 13px; font-size:16px; font-weight:400; line-height:20px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h1 style="color:#274999 !important; margin:0 0 13px; font-size:26px; font-weight:600; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h2 style="color:#274999 !important; margin:0 0 13px; font-size:26px; line-height:26px; font-weight:600; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h3 style="color:#274999 !important; margin:0 0 13px; font-size:26px; line-height:26px; font-weight:600; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h4 style="color:#274999 !important; margin:0 0 13px; font-size:26px; line-height:26px; font-weight:600; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h5 style="color:#274999 !important; margin:0 0 13px; font-size:26px; line-height:26px; font-weight:600; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h6 style="color:#274999 !important; margin:0 0 13px; font-size:26px; line-height:26px; font-weight:600; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<ul>',
                                '<li>',
                                '<ol>',
                                '<td valign="top" width="20">',
                            ],
                        $content) !!}
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td valign="top" height="50"></td>
    </tr>
    <!-- END OF CONTENT AREA -->
@endsection


@section('footer')
    <tr>
        <td colspan="2" align="center" class="smallText">

            {!! str_replace(
                [
                    '<p>',
                    '<h1>',
                    '<h2>',
                    '<h3>',
                    '<h4>',
                    '<h5>',
                    '<h6>',
                    '<ul>',
                    '<li>',
                    '<ol>',
                    '<td>',
                ],
                [
                    '<p style="color:#324E60; margin:0; font-size:12px; font-weight:500; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h2 style="color:#324E60; margin:0 0 10px; font-size:32px; line-height:36px; font-weight:700; letter-spacing:-0.64px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h3 style="color:#324E60; margin:0 0 10px; font-size:24px; line-height:28px; font-weight:700; letter-spacing:-0.48px; font-family: Inter, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h4>',
                    '<h5>',
                    '<h6>',
                    '<ul>',
                    '<li>',
                    '<ol>',
                    '<td valign="top" width="20">',
                ],
            $footer) !!}
        </td>
    </tr>
@endsection
