<?php

namespace Tests\Tenant;

use App\Console\Commands\PurgeOrphanedProviderImages;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\MediaUse;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class PurgeOrphanedProviderImageTest extends TenantTestCase
{
    public function testRemovesOrphanedMediaUses()
    {
        $vehicle = Vehicle::factory()->create(['deleted_at' => '2025-01-01', 'purged_at' => '2025-01-01']);
        $media = Media::factory()->create(['image_provider' => 'foo']);
        $use = MediaUse::factory()->create([
            'media_id' => $media->id,
            'owner_type' => 'vehicle',
            'owner_id' => $vehicle->id,
            'primary' => false,
        ]);

        $this->artisan(PurgeOrphanedProviderImages::class)->assertOk();

        $this->assertFalse(Media::query()->where('id', $media->id)->exists());
        $this->assertFalse(MediaUse::query()->where('id', $use->id)->exists());
    }

    public function testDoesNotRemoveNotDeletedVehicleMedia()
    {
        $vehicle = Vehicle::factory()->create(['deleted_at' => null, 'purged_at' => null]);
        $media = Media::factory()->create(['image_provider' => 'foo']);
        $use = MediaUse::factory()->create([
            'media_id' => $media->id,
            'owner_type' => 'vehicle',
            'owner_id' => $vehicle->id,
            'primary' => false,
        ]);

        $this->artisan(PurgeOrphanedProviderImages::class)->assertOk();

        $this->assertTrue(Media::query()->where('id', $media->id)->exists());
        $this->assertTrue(MediaUse::query()->where('id', $use->id)->exists());
    }

    public function testDoesNotRemoveFilesNotFromProvider()
    {
        $media = Media::factory()->create(['image_provider' => null]);
        $use = MediaUse::factory()->create([
            'media_id' => $media->id,
            'owner_type' => 'vehicle',
            'primary' => false,
        ]);

        $this->artisan(PurgeOrphanedProviderImages::class)->assertOk();

        $this->assertTrue(Media::query()->where('id', $media->id)->exists());
        $this->assertTrue(MediaUse::query()->where('id', $use->id)->exists());
    }

    public function testDoesNotRemoveNotPurgedVehicleMedia()
    {
        Media::factory(10)->create();
        MediaUse::factory(20)->create();
        Vehicle::factory(2)->create();
        $vehicle = Vehicle::factory()->create(['deleted_at' => '2025-01-01', 'purged_at' => null]);
        $media = Media::factory()->create(['image_provider' => 'foo']);
        $use = MediaUse::factory()->create([
            'media_id' => $media->id,
            'owner_type' => 'vehicle',
            'owner_id' => $vehicle->id,
            'primary' => false,
        ]);

        $this->artisan(PurgeOrphanedProviderImages::class)->assertOk();

        $this->assertTrue(Media::query()->where('id', $media->id)->exists());
        $this->assertTrue(MediaUse::query()->where('id', $use->id)->exists());
    }

    public function testDoesNotRemoveWhenMediaHasOtherUses()
    {
        $media = Media::factory()->create(['image_provider' => 'foo']);
        $use = MediaUse::factory()->create([
            'media_id' => $media->id,
            'owner_type' => 'vehicle',
            'primary' => false,
        ]);
        MediaUse::factory()->create([
            'media_id' => $media->id,
            'owner_type' => 'new-car',
        ]);

        $this->artisan(PurgeOrphanedProviderImages::class)->assertOk();

        $this->assertTrue(Media::query()->where('id', $media->id)->exists());
        $this->assertFalse(MediaUse::query()->where('id', $use->id)->exists());
    }
}
