<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\ImportImagesFromUrlList;
use App\Modules\Stock\Skupenet;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Queue;
use Mockery;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class SkupenetTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;
    public function testNameAndDealershipFields()
    {
        $this->assertEquals('Skupenet', (new Skupenet())->name());
        $this->assertArrayHasKey('skupenet-location-id', (new Skupenet())->dealershipAdditionalDataFields());
    }

    public function testImport()
    {
        Queue::fake();
        Http::fake([
            'https://feeds.dealerhub.ie/api/v1/stock?*' => Http::response($this->response()),
            "*" => Http::response([], 400),
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'app-details-currency',
            'value' => 'GBP',
            'type' => 'string'
        ]);

        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'stock-skupenet-sync-images',
            'value' => true,
            'type' => 'boolean'
        ]);

        Dealership::factory()->create(['data' => ['skupenet-location-id' => 123]]);
        (new Skupenet())->runScheduledImport();

        Http::assertSent(function (Request $request) {
            return $request->url() === 'https://feeds.dealerhub.ie/api/v1/stock?dealerIds=123&pageSize=50&page=1';
        });
        $this->assertEquals(2, Vehicle::query()->count());
        $this->assertTrue(Vehicle::query()->where('vrm_condensed', '212D1122')->exists());
        Queue::assertPushed(ImportImagesFromUrlList::class);
    }

    private function response(): array
    {
        return [
            'stock' => [
                [
                    'id' => 123,
                    'dhfDealerId' => 123,
                    'price' => 11223,
                    'currency' => 'GBP',
                    'stockType' => 'CARS',
                    'description' => 'lorem ipsum dolor sit amet',
                    'attributes' => [
                        'registration' => '212D1122',
                        'make' => 'Volkswagen',
                        'model' => 'ID.5',
                        'trim' => 'MAX',
                        'bodyType' => 'Sedan',
                    ],
                    'images' => [
                        [
                            'url' => 'a.com/123',
                        ],
                        [
                            'url' => 'a.com/222',
                        ],
                    ],
                ],
                [
                    'id' => 222,
                    'dhfDealerId' => 123,
                    'price' => 13443,
                    'currency' => 'GBP',
                    'stockType' => 'CARS',
                    'description' => 'lorem ipsum dolor sit amet',
                    'attributes' => [
                        'registration' => '214D1422',
                        'make' => 'Ford',
                        'model' => 'Focus',
                        'bodyType' => 'Sedan',
                    ],
                ],
            ],
            'paging' => [
                'totalPages' => 1,
            ],
        ];
    }
}
