<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use Illuminate\Console\Command;
use App\Jobs\ImportOccupopJobs;
use Illuminate\Foundation\Bus\DispatchesJobs;

class SyncOccupopJobs extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'occupop:sync-jobs';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync Occupop Jobs';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (Settings::get('jobs-occupop-enabled')) {
            $this->dispatch(new ImportOccupopJobs());
        }
        return Command::SUCCESS;
    }
}
