<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FrontEndFinanceCalculatorEnabledSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Finance',
            'group' => 'General',
            'name' => 'Allow customers to adjust finance terms',
            'config_key' => 'finance-front-end-calculator-enabled',
            'type' => 'boolean',
            'value' => false,
            'min_tier' => 'pro',
            'description' => 'When enabled finance adjustments (term/mileage/deposit) will be allowed on vehicle '
                . 'full page advert to adjust finance offer',
            'order' => 40,
        ]);

    }
}
