<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\AaCarsExportJob;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class AaCarsExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('aa-cars-export');
        Vehicle::factory(10)->create();
        Dealership::factory(2)->create();
        Settings::update('sales-channels-aa-cars-file-name', 'foo.csv');
        Settings::update('sales-channels-aa-cars-dealership-file-name', 'faz.csv');

        (new AaCarsExportJob())->handle();

        Storage::disk('aa-cars-export')->assertExists('foo.csv');
        Storage::disk('aa-cars-export')->assertExists('faz.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'aa-cars')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
