<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarWowExportJob;
use App\Modules\SalesChannels\CarWow;
use Database\Seeders\Tenant\CarWowExportSeeder;
use Illuminate\Support\Facades\Queue;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class CarWowExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('car-wow-export');
        $this->seed(CarWowExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-wow-file-name', 'foo.csv');

        (new CarWowExportJob())->handle();

        Storage::disk('car-wow-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-wow')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Storage::fake('car-wow-export');
        $this->seed(CarWowExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-wow-file-name', 'foo.csv');
        Settings::update('sales-channels-car-wow-enabled', true);
        Queue::fake();
        app(CarWow::class)->runScheduledExport();

        Queue::assertPushed(CarWowExportJob::class);
    }
}
