<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class OpenAIEnabledSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Enabled',
                'config_key' => 'open-ai-enabled',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => !empty(Settings::get('open-ai-api_key')),
            ],
        ];
    }
}
