<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;

class SalesforceStockExportTokenSettingSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Salesforce',
                'name' => 'Token expiry time in minutes',
                'config_key' => 'sales-force-stock-export-token-expiry',
                'type' => 'number',
                'value' => 60,
                'validation_rules' => [
                    "required_if:values.sales-force-stock-export-enabled,true"
                ],
            ],
        ];
    }
}
