<?php

namespace App\Exports;

use App\Facades\Settings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\MercuryDataModels\Dealership;

class CarSnipDealerExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Dealership::query()
            ->with([
                'mediaUses.media',
                'dealership',
                'make',
                'model',
                'transmission',
                'fuelType',
                'bodyStyle',
                'specs',
            ])
            ->exportable()
            ->get()
            ->map(function (Dealership $dealership) {
                return [
                    'Dealer_Id' => $dealership->id,
                    'DealerName' => $dealership->name,
                    'StreetName' => $dealership->address1,
                    'Town' => $dealership->city,
                    'Postcode' => $dealership->postcode,
                    'Phone' => $dealership->contact_no,
                    'EmailAddress' => $dealership->email,
                    'WebsiteURL' => Settings::get('app-url'),
                ];
            });
    }

    /**
     * Heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'Dealer_Id',
            'DealerName',
            'StreetName',
            'Town',
            'Postcode',
            'Phone',
            'EmailAddress',
            'WebsiteURL'
        ];
    }
}
