<?php

namespace App\Master\Http\Resources;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use JsonSerializable;

class UserViewResource extends JsonResource
{
    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource['two_factor_enabled'] = !empty($this->resource['two_factor_secret']);
        $data = parent::toArray($request);
        $data['created_at'] = $this->resource->created_at->format('d/m/Y H:i');
        $data['updated_at'] = $this->resource->updated_at->format('d/m/Y H:i');
        return $data;
    }
}
