<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderHubSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'AutoTrader Hub access token',
                'config_key' => 'auto-trader-hub-token',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
                'description' => 'Token is used for connecting to AT Hub and identify site on it.',
                'order' => 99,
            ],
        ];
    }
}
