<?php

namespace Tests\Feature;

use App\Models\ReleaseNote;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class ViewReleaseNoteControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testViewAll()
    {
        ReleaseNote::factory(3)->create(['title' => 'foo', 'is_published' => true]);
        ReleaseNote::factory(2)->create(['title' => 'foo', 'is_published' => false]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.release-notes.view-all'));

        $response->assertStatus(200);
        $this->assertEquals(3, count($response->json('data')));

    }

    public function testView()
    {
        $releaseNote = ReleaseNote::factory()->create(['title' => 'foo', 'is_published' => true]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.release-notes.view', $releaseNote->id));

        $response->assertStatus(200);
        $this->assertEquals($releaseNote->id, $response->json('id'));
        $this->assertEquals('foo', $response->json('title'));

        $releaseNote = ReleaseNote::factory()->create(['title' => 'foo', 'is_published' => false]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.release-notes.view', $releaseNote->id));

        $response->assertStatus(404);
    }
}
