<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use App\Jobs\CarAndDrivingImportJob;
use App\Services\CarAndDrivingService;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\App;

class CarAndDrivingDataImport extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'car-and-driving:bulk-import';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import reviews and other associated data from Car and Driving';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $carAndDrivingService = App::make(CarAndDrivingService::class);
        if (
            $carAndDrivingService->isCarAndDrivingEnabled() === false
            || empty(Settings::get('app-content-car-and-driving-user-id'))
        ) {
            return self::SUCCESS;
        }

        $this->dispatch(new CarAndDrivingImportJob());
        return self::SUCCESS;
    }
}
