<?php

namespace App\Services;

use App\Facades\Settings;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class Occupop
{
    /**
     * Get Jobs From API
     *
     */
    public function getJobs()
    {
        $response = Http::get($this->endpoint() . '?visibility=external&json');

        if ($response->successful()) {
            $jobs = $response->json('jobs');
            if (!empty($jobs)) {
                return $jobs;
            }
        }

        Log::warning('Failed to fetch jobs from Occupop: ' . tenant()->name);

        return [];
    }

    protected function endpoint(): string
    {
        return config('services.occupop.endpoint') . Settings::get('jobs-occupop-api_key');
    }
}
