<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderLookupSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'AutoTrader',
                'name' => 'Enabled',
                'config_key' => 'lookup-auto-trader-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'UK MOT',
                'name' => 'Enabled',
                'config_key' => 'lookup-uk-mot',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
        ];
    }
}
