<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MultiFranchiseDealershipSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Multi-franchise dealerships',
                'config_key' => 'dealerships-multiple-franchises',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Allows assigning multiple franchises to a dealership',
            ],
        ];
    }
}
