<?php

namespace Tests\Tenant;

use App\Imports\AutoTraderApiToVehicleImport;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class AutoTraderApiToVehicleImportTest extends TenantTestCase
{
    protected AutoTraderApiToVehicleImport $importer;

    protected function setUp(): void
    {
        parent::setUp();
        $this->importer = new AutoTraderApiToVehicleImport();
        $this->importer->setDealershipId(1); // example dealership
    }

    public function testExistsReturnsTrueWhenVehicleWithUuidExists()
    {
        Vehicle::factory()->create([
            'stock_provider' => 'auto-trader',
            'uuid' => 'autotrader-uuid-123',
        ]);

        $vehicleData = [
            'metadata' => ['stockId' => 'autotrader-uuid-123'],
            'vehicle' => ['registration' => 'AB12CDE', 'vin' => 'VIN123']
        ];

        $this->assertTrue($this->importer->exists($vehicleData));
    }

    public function testExistsReturnsTrueWhenVehicleWithVinExists()
    {
        Vehicle::factory()->create([
            'stock_provider' => 'auto-trader',
            'vin' => 'VIN123'
        ]);

        $vehicleData = [
            'metadata' => ['stockId' => 'non-matching-id'],
            'vehicle' => ['registration' => 'AB12CDE', 'vin' => 'VIN123']
        ];

        $this->assertTrue($this->importer->exists($vehicleData));
    }


}
