<?php

namespace Tests\Tenant;

use App\Console\Commands\GenerateReportingStats;
use App\Reporting\StatsModels\EnquiriesPerDay;
use Carbon\Carbon;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\ReportingStat;
use Tests\TenantTestCase;

class GenerateReportingStatsTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testGenerateStats()
    {
        Config::set('stats-types', [
            'enquiries-per-day' => EnquiriesPerDay::class,
        ]);

        $response = $this->artisan(GenerateReportingStats::class);
        $response->run();
        $response->assertExitCode(0);

        $this->assertTrue(ReportingStat::query()->where('date', Carbon::yesterday())->exists());
    }
}
